<?php
/* Copyright (C) 2016		 Oscss-Shop       <support@oscss-shop.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */


class Fixversion{

	public 
	/**
		@var
	*/
			$tbl = array()
	/**
		@var
	*/
		, $col = array() 
	/**
		@var
	*/
		, $last = array() 
	/**
		@var
	*/
		, $corss=array(
					'agenda'=>array(
						'name'=>"Agenda",
						'title'=>"Agenda",
						'class'=>'ActionComm',
						'table'=>'actioncomm',
						'datefieldname'=>'datep',
						'path'=>'comm/action/',
						'disableamount'=>1,
						// tabs 
						'nameid'=>'id',
						'tabs'=>'agenda',
						// rights
						'rights'=>'agenda',
						
						'lang'=>'agenda'
						),
						
					
					
						
					'contact'=>array(
						'name'=>"Contact",
						'class'=>'Contact',
						'table'=>'socpeople',
						'datefieldname'=>'datec',
						'path'=>'contact/',
						'tabs'=>'contact',
						// tabs 
						'nameid'=>'id',
						'lang'=>'company', 
						// rights
						'rights'=>'societe->contact',
						
						),
					'contract'=>array(
						'name'=>"Contracts",
						'title'=>"ListContractAssociatedQualityreport",
						'class'=>'Contrat',
						'table'=>'contrat',
						'datefieldname'=>'date_contrat',
						'path'=>'contrat/',
						// tabs 
						'nameid'=>'id',
						'tabs'=>'contract',
						
						'lang'=>'contract'
						),
						
						
						
					'donation'=>array(
						'name'=>"Donation",
						'title'=>"Donation",
						'class'=>'Don',
						'table'=>'don',
						'datefieldname'=>'datedon',
						'path'=>'don/',
						'margin'=>'add',
						// tabs 
						'nameid'=>'id',
						'tabs'=>'donation',
						// rights
						'rights'=>'don',
						
						'lang'=>'donations'
						),
						
						
						
					'expensereport'=>array(
						'name'=>"ExpenseReports",
						'title'=>"ExpenseReports",
						'class'=>'ExpenseReportLine',
						'table'=>'expensereport_det',
						'datefieldname'=>'date',
						'path'=>'expensereport/',
						'margin'=>'minus',
						'disableamount'=>0,
						// tabs 
						'nameid'=>'id',
						'tabs'=>'expensereport',
						// rights
						'rights'=>'expensereport',
						
						'lang'=>'trips'
						),
						
						
						
					'fichinter'=>array(
						'name'=>"Fichinter",
						'title'=>"Fichinter",
						'class'=>'Fichinter',
						'table'=>'fichinter',
						'datefieldname'=>'date_valid',
						'path'=>'fichinter/',
						// tabs 
						'nameid'=>'id',
						'tabs'=>'fichinter',
						
						'lang'=>'interventions'
						),
						
						
						
					'group'=>array(
						'name'=>"Groups",
						'class'=>'UserGroup',
						'table'=>'usergroup',
						'datefieldname'=>'datep',
						'path'=>'group/',
						'tabs'=>'group',
						// tabs
						'nameid'=>'id',
						'lang'=>'usergroup'
						),
						
						
						
					'invoice'=>array(
						'name'=>"CustomersInvoices",
						'class'=>'Facture',
						'table'=>'facture',
						'datefieldname'=>'datef',
						'path'=>'compta/facture/',
						// tabs 
						'nameid'=>'facid',
						'tabs'=>'invoice',
						'lang'=>'bills',
						
						// rights
						'rights'=>'facture',
						// retro 
						'oldtype'=>'facture'

						),
					'invoice_supplier'=>array(
						'name'=>"BillsSuppliers",
						'class'=>'FactureFournisseur',
						'table'=>'facture_fourn',
						'datefieldname'=>'datef',
						'path'=>'fourn/facture/',
						// tabs 
						'nameid'=>'facid',
						'tabs'=>'supplier_invoice',
						
						'lang'=>'suppliers'
						),
					'invoice_predefined'=>array(
						'name'=>"PredefinedInvoices",
						'class'=>'FactureRec',
						'table'=>'facture_rec',
						'datefieldname'=>'datec',
						'path'=>'supplier_proposal/',
						// tabs 
						'nameid'=>'id',
						'tabs'=>'invoice_predefined',
						'lang'=>'bills'
						),
						
						
						
					'order'=>array(
						'name'=>"CustomersOrders",
						'class'=>'Commande',
						'table'=>'commande',
						'datefieldname'=>'date_commande',
						'path'=>'commande/',
						// tabs 
						'nameid'=>'id',
						'tabs'=>'order',
						'lang'=>'orders',
						
						// rights
						'rights'=>'commande',
						// retro 
						'oldtype'=>'commande'
						),
					'order_supplier'=>array(
						'name'=>"SuppliersOrders",
						'class'=>'CommandeFournisseur',
						'table'=>'commande_fournisseur',
						'datefieldname'=>'date_commande',
						'path'=>'fourn/commande/',
						// tabs 
						'nameid'=>'id',
						'tabs'=>'supplier_order',
						
						'lang'=>'suppliers'
						),
						
						
						
						
					'propal'=>array(
						'name'=>"Proposals",
						'class'=>'Propal',
						'table'=>'propal',
						'datefieldname'=>'datep',
						'path'=>'comm/propal/',
						'tabs'=>'propal',
						// tabs 
						'nameid'=>'id',
						'lang'=>'propal'
						),
					'proposal_supplier'=>array(
						'name'=>"SuppliersProposals",
						'class'=>'SupplierProposal',
						'table'=>'supplier_proposal',
						'datefieldname'=>'date',
						'path'=>'fourn/facture/',
						// tabs 
						'nameid'=>'id',
						'tabs'=>'proposal_supplier',
						
						'lang'=>'supplier_proposal'
						),
					'product'=>array(
						'name'=>"Product",
						'title'=>"Products",
						'class'=>'Product',
						'table'=>'product',
						'datefieldname'=>'date_contrat',
						'path'=>'product/',
						// tabs 
						'nameid'=>'id',
						'tabs'=>'product',
						
						'lang'=>'product'
						),
						
						
						
						
					'thirdparty'=>array(
						'name'=>"Thirdparty",
						'class'=>'Societe',
						'table'=>'societe',
						'datefieldname'=>'datep',
						'path'=>'societe/',
						'tabs'=>'thirdparty',
						// rights
						'rights'=>'societe',
						// tabs 
						'nameid'=>'socid',
						'lang'=>'company',
						
						// retro 
						'oldtype'=>'societe'
						),
					'trip'=>array(
						'name'=>"TripsAndExpenses",
						'title'=>"TripsAndExpenses",
						'class'=>'Deplacement',
						'table'=>'deplacement',
						'datefieldname'=>'dated',
						'path'=>'deplacement/',
						'margin'=>'minus',
						'disableamount'=>1,
						// tabs 
						'nameid'=>'id',
						'tabs'=>'trip',
						// rights
						'rights'=>'deplacement',
						
						'lang'=>'trips'
						),
						
						
						
					
						
					'user'=>array(
						'name'=>"Users",
						'class'=>'User',
						'table'=>'user',
						'datefieldname'=>'datep',
						'path'=>'user/',
						'tabs'=>'user',
						// tabs
						'nameid'=>'id',
						'lang'=>'user'
						),
						
			);
			
			
		
	/**
		@var protected
	*/
	protected 
				$dolv = 0
		 , 	$shortdolv = 0
			/**
				@var array list ressource based on class name
			*/
		 , $byclassname = array();
	
	public function __construct($db){
		$this->db= $db; 
		$this->dolv= DOL_VERSION; 
		$this->shortdolv =  substr(DOL_VERSION, 0, -2);
		
		
		global $conf; 

		
		foreach($conf->modules_parts['hooks'] as $k=>$r )
			if(!isset($this->corss[$k])){
				if(dol_buildpath('/'.$k.'/class/'.$k.'.class.php',1) !=false ) {
				$this->corss[$k]=array(
						'name'=>$k,
						'title'=>ucwords($k),
						'class'=>ucwords($k),
						'table'=>$k,
// 						'datefieldname'=>'date_contrat',
						'path'=>strtolower($k).'/',
						// tabs 
						'nameid'=>'id',
						'tabs'=>$k ,
						
						'rights'=>$k ,
						
						'lang'=>$k
						);
			}
			}
			
			
		foreach($this->corss as $k=>$r){
			
			$r['type'] = $k; 
			$r['oldtype'] = (isset($r['oldtype']) ? $r['oldtype'] : $k);
			$r['rights'] = (isset($r['rights']) ? $r['rights'] : $k);
			
			$this->byclassname[strtolower($r['class'])] = $r; 
			
			$this->bytypename[strtolower($k)] = $r;
			
			// retor compatibility
			// for used old type
			$this->byoldtypename[ strtolower( (isset($r['oldtype']) ? $r['oldtype'] : $k) ) ] = $r; 
		}
		
		
	}
	
	/**
		@fn GetTbl($table)
		@brief 
	*/
	public function __call($name, $args) {
	
		if(substr($name, 0,3) === 'Get')  {
			preg_match_all('#([A-Z][a-z]*)#', $name, $match); 
			

			$vars = 'by'.strtolower($match[0][3]).'name';
			// call current val 
			if(count($this->last)>0 && empty($args[0]) ){
					if(isset($this->last[strtolower($match[0][1])] ) )
						return $this->last[strtolower($match[0][1])];
			}
			elseif(isset($this->{$vars})) {
				if(is_string($args[0]) && isset($this->{$vars}[strtolower($args[0])])){
					$this->SetLast( $this->{$vars}[strtolower($args[0])] ); 
	
					if(isset($this->last[strtolower($match[0][1])] ) )
						return $this->last[strtolower($match[0][1])];
					else 
						return false; 
				}
				elseif(strtolower($match[0][3]) =='oldtype' ){
					$vars = 'bytypename';
					if(isset($this->{$vars})) {
						if(is_string($args[0]) && isset($this->{$vars}[strtolower($args[0])])){
							$this->SetLast( $this->{$vars}[strtolower($args[0])] ); 
			
							if(isset($this->last[strtolower($match[0][1])] ) )
								return $this->last[strtolower($match[0][1])];
							else 
								return false; 
						}
					}
				}
				return $this->{$vars};
			}
		}
		return false;
	}
    
	public function SetLast($array){
		$this->last = $array; 
	}

	/**
		@fn GetTypeByClassName($table)
		@brief 
	*/
// 	public function GetTypeByClassName($classname){
// 		$class = strtolower($classname);
// 		if(isset($this->byclassname[$class])) 
// 			return $this->byclassname[$class]['type'];
// 
// 		return $class;
// 	}
	
	
	/**
		@fn GetTbl($table)
		@brief 
	*/
	public function GetTbl($table){
		if(isset($this->tbl[$table])) 
			return $this->tbl[$table];

		return $table;
	}
	
	/**
		@fn GetCol($name, $table)
		@brief 
	*/
	public function GetCol($name, $table){
		if(isset($this->col[$name])) 
			return $this->col[$name];
		elseif(isset($this->col[$table][$name])) 
			return $this->col[$table][$name];

			
		return $name;
	}
}
