<?php
/* Copyright (C) 2008-2017 Laurent Destailleur  <eldy@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\file       	htdocs/ecm/class/htmlecm.form.class.php
 * 	\brief      	File of class to manage HTML component for ECM and generic filemanager
 */
require_once DOL_DOCUMENT_ROOT.'/ecm/class/ecmdirectory.class.php';


/**
 * Class to manage HTML component for ECM and generic filemanager
 */
class FormEcm
	Extends FormEcm
{

namespace CORE;

 dol_include_once('/ecm/class/htmlecm.form.class.php');


namespace CORE\FRAMEWORK;
use \CORE\FRAMEWORK\FormEcm as FormEcm ;

	public $OSE_loaded_version = DOL_VERSION;
 
	/**
	 *	Return list of sections
	 *
	 *  @param	int		$selected    		Id of preselected section
	 *  @param  string	$select_name		Name of HTML select component
	 *  @param	string	$module				Module ('ecm', 'medias', ...)
	 *  @return	string						String with HTML select
	 */
	public function selectAllSections($selected=0, $select_name='', $module='ecm'){
		return $this->select_all_sections($selected, $select_name, $module); 
	}
	


}


