<?php
/* Copyright (C) 2008-2011 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2019 Catriel Rios <catriel_r@hotmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

/**
 *	\file       htdocs/directprintwhb/admin/terminal.php
 *	\ingroup    takepos
 *	\brief      Setup page for directprintwhb module
 */
// Load Dolibarr environment
$res = 0;
// Try main.inc.php into web root known defined into CONTEXT_DOCUMENT_ROOT (not always defined)
if (!$res && !empty($_SERVER["CONTEXT_DOCUMENT_ROOT"])) $res = @include $_SERVER["CONTEXT_DOCUMENT_ROOT"]."/main.inc.php";
// Try main.inc.php into web root detected using web root calculated from SCRIPT_FILENAME
$tmp = empty($_SERVER['SCRIPT_FILENAME']) ? '' : $_SERVER['SCRIPT_FILENAME']; $tmp2 = realpath(__FILE__); $i = strlen($tmp) - 1; $j = strlen($tmp2) - 1;
while ($i > 0 && $j > 0 && isset($tmp[$i]) && isset($tmp2[$j]) && $tmp[$i] == $tmp2[$j]) { $i--; $j--; }
if (!$res && $i > 0 && file_exists(substr($tmp, 0, ($i + 1))."/main.inc.php")) $res = @include substr($tmp, 0, ($i + 1))."/main.inc.php";
if (!$res && $i > 0 && file_exists(dirname(substr($tmp, 0, ($i + 1)))."/main.inc.php")) $res = @include dirname(substr($tmp, 0, ($i + 1)))."/main.inc.php";
// Try main.inc.php using relative path
if (!$res && file_exists("../main.inc.php")) $res = @include "../main.inc.php";
if (!$res && file_exists("../../main.inc.php")) $res = @include "../../main.inc.php";
if (!$res && file_exists("../../../main.inc.php")) $res = @include "../../../main.inc.php";
if (!$res) die("Include of main fails");


require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/product/class/html.formproduct.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/pdf.lib.php';
require_once DOL_DOCUMENT_ROOT.'/categories/class/categorie.class.php';
require_once dol_buildpath("/directprintwhb/lib/directprintwhb.lib.php");


$terminal = GETPOST('terminal', 'int');

// Security check
if (!$user->admin) accessforbidden();

$langs->loadLangs(array("admin", "directprintwhb", "printing", "receiptprinter"));

global $db, $conf;



$terminaltouse = $terminal;


/*
 * Actions
 */

if (GETPOST('action', 'alpha') == 'set')
{
	$db->begin();

	$res = dolibarr_set_const($db, "DIRECTPRINTWHB_IPADDRESS".$terminaltouse, (GETPOST('DIRECTPRINTWHB_IPADDRESS'.$terminaltouse, 'alpha') ? GETPOST('DIRECTPRINTWHB_IPADDRESS'.$terminaltouse, 'alpha') : ''), 'chaine', 0, '', $conf->entity);
	$res = dolibarr_set_const($db, "DIRECTPRINTWHB_PORT".$terminaltouse,      (GETPOST('DIRECTPRINTWHB_PORT'.$terminaltouse, 'alpha') > 0 ? GETPOST('DIRECTPRINTWHB_PORT'.$terminaltouse, 'alpha') : ''), 'chaine', 0, '', $conf->entity);
	$res = dolibarr_set_const($db, "DIRECTPRINTWHB_SECURE".$terminaltouse,  (GETPOST('DIRECTPRINTWHB_SECURE'.$terminaltouse, 'alpha')  ? GETPOST('DIRECTPRINTWHB_SECURE'.$terminaltouse, 'alpha') : ''), 'chaine', 0, '', $conf->entity);
	$res = dolibarr_set_const($db, "DIRECTPRINTWHB_ACCESSTOKEN".$terminaltouse,  (GETPOST('DIRECTPRINTWHB_ACCESSTOKEN'.$terminaltouse, 'alpha')  ? GETPOST('DIRECTPRINTWHB_SERIALID'.$terminaltouse, 'alpha') : ''), 'chaine', 0, '', $conf->entity);

	$res = dolibarr_set_const($db, "DIRECTPRINTWHB_BEPRINTERID".$terminaltouse,  (GETPOST('DIRECTPRINTWHB_BEPRINTERID'.$terminaltouse, 'alpha')  ? GETPOST('DIRECTPRINTWHB_BEPRINTERID'.$terminaltouse, 'alpha') : ''), 'chaine', 0, '', $conf->entity);
	$res = dolibarr_set_const($db, "DIRECTPRINTWHB_TPSERIALID".$terminaltouse,  (GETPOST('DIRECTPRINTWHB_TPSERIALID'.$terminaltouse, 'alpha')  ? GETPOST('DIRECTPRINTWHB_TPSERIALID'.$terminaltouse, 'alpha') : ''), 'chaine', 0, '', $conf->entity);

	$res = dolibarr_set_const($db, "DIRECTPRINTWHB_TPPRINTERID".$terminaltouse,  (GETPOST('DIRECTPRINTWHB_TPPRINTERID'.$terminaltouse, 'alpha')  ? GETPOST('DIRECTPRINTWHB_TPPRINTERID'.$terminaltouse, 'alpha') : ''), 'chaine', 0, '', $conf->entity);
	$res = dolibarr_set_const($db, "DIRECTPRINTWHB_ORDER_TPPRINTERID".$terminaltouse.'_1',  (GETPOST('DIRECTPRINTWHB_ORDER_TPPRINTERID'.$terminaltouse.'_1', 'alpha')  ? GETPOST('DIRECTPRINTWHB_ORDER_TPPRINTERID'.$terminaltouse.'_1', 'alpha') : ''), 'chaine', 0, '', $conf->entity);
	$res = dolibarr_set_const($db, "DIRECTPRINTWHB_ORDER_TPPRINTERID".$terminaltouse.'_2',  (GETPOST('DIRECTPRINTWHB_ORDER_TPPRINTERID'.$terminaltouse.'_2', 'alpha')  ? GETPOST('DIRECTPRINTWHB_ORDER_TPPRINTERID'.$terminaltouse.'_2', 'alpha') : ''), 'chaine', 0, '', $conf->entity);
	$res = dolibarr_set_const($db, "DIRECTPRINTWHB_ORDER_TPPRINTERID".$terminaltouse.'_3',  (GETPOST('DIRECTPRINTWHB_ORDER_TPPRINTERID'.$terminaltouse.'_3', 'alpha')  ? GETPOST('DIRECTPRINTWHB_ORDER_TPPRINTERID'.$terminaltouse.'_3', 'alpha') : ''), 'chaine', 0, '', $conf->entity);


	dol_syslog("admin/directprintwhb: level ".GETPOST('level', 'alpha'));

	if (!($res > 0)) $error++;

 	if (!$error)
	{
		$db->commit();
		setEventMessages($langs->trans("SetupSaved"), null, 'mesgs');
	} else {
		$db->rollback();
		setEventMessages($langs->trans("Error"), null, 'errors');
	}
}
$ws = 'ws://';
//if ($conf->global->{'DIRECTPRINTWHB_SECURE'.$terminaltouse}) $ws = 'wss://';

/*
 * View
 */

$form = new Form($db);
$formproduct = new FormProduct($db);

llxHeader('', $langs->trans("DirectPrintWHBSetup"));

$linkback = '<a href="'.DOL_URL_ROOT.'/admin/modules.php">'.$langs->trans("BackToModuleList").'</a>';
print load_fiche_titre($langs->trans("DirectPrintWHBSetup").' (TakePOS)', $linkback, 'title_setup');
$head = directprintwhbAdminPrepareHead();
print dol_get_fiche_head($head, 'terminal'.$terminal, 'TakePOS', -1, 'cash-register');
print '<br>';

// Mode
print '<form action="'.$_SERVER["PHP_SELF"].'?terminal='.(empty($terminal) ? 0 : $terminal).'" method="post">';
print '<input type="hidden" name="token" value="'.newToken().'">';
print '<input type="hidden" name="action" value="set">';

print '<div class="div-table-responsive">';
print '<table class="noborder centpercent">';
print '<tr class="liste_titre">';
print '<td>'.$langs->trans("Parameters").'</td><td>'.$langs->trans("Value").'</td>';
print "</tr>\n";


$atleastonefound = 0;

	print '<tr class="oddeven"><td>'.$langs->trans("DIRECTPRINTWHB_IPADDRESS").'</td>';
	print '<td>';
	print '<input type="text" id="ipaddress" name="DIRECTPRINTWHB_IPADDRESS'.$terminaltouse.'" value="'.$conf->global->{'DIRECTPRINTWHB_IPADDRESS'.$terminaltouse}.'" />';
	print '</td></tr>';

    print '<tr class="oddeven"><td>'.$langs->trans("DIRECTPRINTWHB_PORT").'</td>';
    print '<td>';
    print '<input type="text" id="port" name="DIRECTPRINTWHB_PORT'.$terminaltouse.'" value="'.$conf->global->{'DIRECTPRINTWHB_PORT'.$terminaltouse}.'" />';
    print '</td></tr>';

	print '<tr class="oddeven"><td>'.$langs->trans("DIRECTPRINTWHB_SECURE").'</td>';
	print '<td>';
	print '<input type="checkbox" id="secure" name="DIRECTPRINTWHB_SECURE'.$terminaltouse.'" value="1" '.(($conf->global->{'DIRECTPRINTWHB_SECURE'.$terminaltouse}) ? 'checked="checked"' : "").'" />';
	print '</td></tr>';


	print '<tr class="oddeven"><td>'.$langs->trans("DIRECTPRINTWHB_ACCESSTOKEN").'</td>';
    print '<td>';
    print '<input type="text" id="accesstoken" name="DIRECTPRINTWHB_ACCESSTOKEN'.$terminaltouse.'" value="'.$conf->global->{'DIRECTPRINTWHB_ACCESSTOKEN'.$terminaltouse}.'" />';
    print '</td></tr>';

if ($terminaltouse == 0) {
	print '<tr class="liste_titre">';
	print '<td colspan="2">' . $langs->trans("DirectPrint") . '  </td>';
	print "</tr>\n";

	print '<tr class="oddeven"><td>' . $langs->trans("BackendPrinterToUse") . '</td>';
	print '<td>';
	print '<input type="text" id="beprinterid" name="DIRECTPRINTWHB_BEPRINTERID' . $terminaltouse . '" value="' . $conf->global->{'DIRECTPRINTWHB_BEPRINTERID' . $terminaltouse} . '" />';
	print '</td></tr>';

}

	print '<tr class="liste_titre">';
	print '<td colspan="2">' . $langs->trans("ReceiptPrinter") . '  </td>';
	print "</tr>\n";

	print '<tr class="oddeven"><td>' . $langs->trans("MainPrinterToUse") . '</td>';
	print '<td>';
	print '<input type="text" id="printerid" name="DIRECTPRINTWHB_TPPRINTERID' . $terminaltouse . '" value="' . $conf->global->{'DIRECTPRINTWHB_TPPRINTERID' . $terminaltouse} . '" />';
	print '</td></tr>';



	print '<tr class="oddeven"><td>' . $langs->trans("OrderPrinterToUse") . '</td>';
	print '<td>';
	print '<input type="text" id="printer1id" name="DIRECTPRINTWHB_ORDER_TPPRINTERID' . $terminaltouse .'_1'. '" value="' . $conf->global->{'DIRECTPRINTWHB_ORDER_TPPRINTERID' . $terminaltouse.'_1'} . '" />';
	print '</td></tr>';


	print '<tr class="oddeven"><td>' . $langs->trans("OrderPrinterToUse") . '</td>';
	print '<td>';
	print '<input type="text" id="printer2id" name="DIRECTPRINTWHB_ORDER_TPPRINTERID' . $terminaltouse .'_2'. '" value="' . $conf->global->{'DIRECTPRINTWHB_ORDER_TPPRINTERID' . $terminaltouse.'_2'} . '" />';
	print '</td></tr>';


	print '<tr class="oddeven"><td>' . $langs->trans("OrderPrinterToUse") . '</td>';
	print '<td>';
	print '<input type="text" id="printer3id" name="DIRECTPRINTWHB_ORDER_TPPRINTERID' . $terminaltouse  .'_3'. '" value="' . $conf->global->{'DIRECTPRINTWHB_ORDER_TPPRINTERID' . $terminaltouse.'_3'} . '" />';
	print '</td></tr>';

	print '<tr class="oddeven"><td>' . $langs->trans("WeighingScale") . '</td>';
	print '<td>';
	print '<input type="text" id="serialid" name="DIRECTPRINTWHB_TPSERIALID' . $terminaltouse . '" value="' . $conf->global->{'DIRECTPRINTWHB_TPSERIALID' . $terminaltouse} . '" />';
	print '</td></tr>';

//}

	print '</table>';
	print '</div>';




print '<br>';

print '<div class="center"><input type="submit" class="button button-save" value="'.$langs->trans("Save").'"></div>';

print "</form>\n";

print '<br>';

print '<script type="text/javascript"></script>';
//print '<script src="'.dol_buildpath('/directprintwhb',2).'/js/websocket-printer.js"></script>';
print '

<script>
    var printService = new WebSocketPrinter({
        url: "'.$ws.$conf->global->{'DIRECTPRINTWHB_IPADDRESS'.$terminaltouse}.':' .$conf->global->{'DIRECTPRINTWHB_PORT'.$terminaltouse}.'/printer",

        onConnect: function () {
             $.jnotify("'.$langs->trans('Connected').'",
            "info",
            {timeout: 5},
            {
                remove: function () {}
            });

           console.log(\'Connected\');
        },
        onDisconnect: function () {
             $.jnotify("'.$langs->trans('Disconnected').'",
            "error",
            {timeout: 5},
            {
                remove: function () {}
            });
           console.log(\'Disconnected\');
        },
        onUpdate: function (message) {
         $.jnotify(message,
            "info",
            {timeout: 5},
            {
                remove: function () {}
            });

            console.log (message);
        },
    });




';
print '</script>';


llxFooter();
$db->close();
