<?php

/**
 * This file was generated by DAMB
 *
 * @copyright   Copyright (c) 2019 - 2020, AXeL-dev
 * @license     GPL
 * @link        https://github.com/AXeL-dev/damb
 */

// Load Dolibarr environment (mandatory)
if (false === (@include_once '../../main.inc.php')) { // From htdocs directory
    require_once '../../../main.inc.php'; // From "custom" directory
}

// Load extrafields & form class
require_once DOL_DOCUMENT_ROOT . '/core/class/extrafields.class.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/html.form.class.php';

// Load page & ${module_folder} lib
dol_include_once('${module_folder}/lib/page.lib.php');
dol_include_once('${module_folder}/lib/${module_folder}.lib.php');

// Control access to page
control_access('$user->admin');

// Get parameters
$action = GETPOST('action', 'alpha');
$attrname = GETPOST('attrname', 'alpha');

/**
 * Actions
 */

global $db, $langs, $conf;

$elementtype = '${element_type}'; // extrafields table name without '_extrafields'
$extrafields = new ExtraFields($db);

include_once DOL_DOCUMENT_ROOT.'/core/actions_extrafields.inc.php';

/**
 * View
 */

print_header('ExtraFields', array('admin', '${lang_file}@${module_folder}'));

print_subtitle('ExtraFields', 'title_generic.png', 'link:modules_list');

print_admin_tabs('ExtraFields');

// Set required variables
$form = new Form($db);
$textobject = $langs->trans('${text_object}'); // object name/text, e.: 'MyObject'

// List of supported format
$tmptype2label = ExtraFields::$type2label;
$type2label    = array();
$type2label[]  = ''; // adds an empty option
foreach ($tmptype2label as $key => $val) {
    $type2label[$key] = $langs->transnoentitiesnoconv($val);
}

// Extrafields view/table
include_once DOL_DOCUMENT_ROOT.'/core/tpl/admin_extrafields_view.tpl.php';

// Buttons
if ($action != 'create' && $action != 'edit')
{
    echo '<div class="tabsAction">';
    echo '<div class="inline-block divButAction"><a class="butAction" href="'.$_SERVER["PHP_SELF"].'?action=create">'.$langs->trans('NewAttribute').'</a></div>';
    echo '</div>';
}

// Add form
if ($action == 'create')
{
    echo '<br>';
    echo load_fiche_titre($langs->trans('NewAttribute'));

    include_once DOL_DOCUMENT_ROOT.'/core/tpl/admin_extrafields_add.tpl.php';
}

// Edit form
if ($action == 'edit' && ! empty($attrname))
{
    echo '<br>';
    echo load_fiche_titre($langs->trans('FieldEdition', $attrname));

    include_once DOL_DOCUMENT_ROOT.'/core/tpl/admin_extrafields_edit.tpl.php';
}

print_footer(true);
